###########################################################################################
# imports des modules et des données nécessaires                         NE PAS MODIFIER  #
###########################################################################################

from module_arbre import *
from stock import DONNEES_STOCK

###########################################################################################
# QUESTION 1: Insérer un produit                                                          #
###########################################################################################

#1.1 Compléter les deux lignes (pass)

def inserer_produit_dans_stock(arbre_stock, nouveau_produit):
    """
    Insère un objet Produit dans la structure arborescente de l'objet Stock.
    La comparaison (clé) se fait sur l'id_produit.
    Paramètres:
    - arbre_stock (Stock): arbre dans lequel on veut insérer le nouveau produit
    - nouveau_produit (Produit): produit à insérer
    Retour:
    - arbre_stock (Stock): Arbre dans lequel le nouveau produit  a été inséré
    """
    # CAS 1 : Le stock est vide (on remplit la racine)
    if arbre_stock.valeur is None:
        arbre_stock.valeur = nouveau_produit        

    # CAS 2 : Comparaison des clés pour le placement    
    cle_inseree = nouveau_produit.id_produit
    cle_actuelle = arbre_stock.valeur.id_produit

    if cle_inseree < cle_actuelle:
        if arbre_stock.gauche is None:
            # On crée un nouveau maillon Stock pour le produit
            arbre_stock.gauche = Stock(nouveau_produit)
        else:
            # Descente récursive à gauche
            pass
            
    elif cle_inseree > cle_actuelle:
        if arbre_stock.droit is None:
            # On crée un nouveau maillon Stock pour le produit
            arbre_stock.droit = Stock(nouveau_produit)
        else:
            # Descente récursive à droite
            pass

#1.2 : Tester le code ci-dessous
'''            
# 1. Instanciation du stock vide
mon_magasin = Stock()

# 2. Boucle de création et d'insertion des produits
for produit in DONNEES_STOCK:
    # On crée l'objet Produit
    obj_p = Produit(produit["id_produit"], produit["nom"], produit["quantite"], produit["prix_unitaire"])    
    # On l'insère via la fonction 
    inserer_produit_dans_stock(mon_magasin, obj_p)

# 3. Visualisation finale
print("Visualisation de l'arbre modélisant le stock du magasin:")
mon_magasin.visualiser()
'''


#1.3 : Compléter les tests.

#assert mon_magasin.gauche.valeur.id_produit == ...
#assert mon_magasin.droit.valeur.id_produit == ...
#assert mon_magasin.valeur.id_produit == ...
#assert mon_magasin.droit.gauche.valeur.id_produit==



###########################################################################################
# QUESTION 2 : Stock Total                                                                 #
###########################################################################################


# 2.1  :  Modifier

def calculer_stock_total(arbre_stock):
    """
    Calcule le nombre d'objets dans le stock
    Paramètres:
    - arbre_stock (Stock): arbre modélisant le stock du magasin
    Retour:
    - somme (int): nombre d'objets dans le stock
    """
    if arbre_stock is None or arbre_stock.valeur is None:
        return 0
    else:
        return arbre_stock.valeur.quantite + calculer_stock_total(arbre_stock.gauche) + calculer_stock_total(arbre_stock.droit)


# 2.2 :  TEST

#assert calculer_stock_total(mon_magasin) == 291659.9




###########################################################################################
# QUESTION 3 : Rechercher un produit                                                       #
###########################################################################################

# 3.1 :  Compléter 

def rechercher_produit(arbre_stock, id_recherche):
    """
    Recherche un produit par son ID dans l'arborescence du stock.
    Renvoie l'objet Produit s'il est trouvé, sinon None.
    Paramètres:
    - arbre_stock (Stock): arbre dans lequel on veut chercher un produit
    - id_recherche (int): identifiant du produit recherché
    Retour:
    - produit (Produit): produit recherché s'il est présent, None sinon
    """
    # CAS 1 : Le stock est vide ou on a atteint une feuille sans trouver
    # A compléter

    # CAS 2 : On a trouvé le produit
    id_actuel = arbre_stock.valeur.id_produit
    
    if id_recherche == id_actuel:
        return arbre_stock.valeur
    
    # CAS 3 : Recherche récursive selon la structure de l'ABR
    elif id_recherche < id_actuel:
        # On cherche dans le sous-arbre gauche
        # A compléter
    else:
        # On cherche dans le sous-arbre droit
        # A compléter
 
# 3.2 :  TESTS
#assert rechercher_produit(mon_magasin, 50).nom == "Clavier Mécanique"
#assert rechercher_produit(mon_magasin, 81) == None
#assert rechercher_produit(mon_magasin, 5).nom=="Adaptateur USB-A vers C"




###########################################################################################
# QUESTION 4: Parcours                                                             #
###########################################################################################

# 4.1. Quel parcours permet d'avoir les nœuds d'un arbre binaire dans l'ordre croissant ?

#Réponse 

# 4.2

inventaire=[]
def parcours(arbre_stock):
    global L
    """
    Parcourt l'arbre  et renvoie une liste 
    contenant les objets Produit triés par ID.
    Paramètres:
    - arbre_stock (Stock): arbre modélisant le stock du magasin
    Retour:
    - parcours (list): parcours de l'arbre
    """
    # Cas de base : si le nœud est vide ou None
    # A compléter 
    else :
        # On parcours l'arbre gauche puis
        # on ajoute la racine de l'arbre à L puis
        # On parcours l'arbre droit
        
        
        
    

# 4.3 :  TESTS

#parcours(mon_magasin)
#assert inventaire[0].id_produit == 5
#assert inventaire[-1].id_produit == 130

# 4.4



